/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import com.google.common.base.MoreObjects;
import net.minecraft.network.PacketBuffer;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.PlayerState;

public final class SyncMovementMsg {
    public final PlayerState state;
    public final int stamina;
    public final boolean depleted;
    public final int recoveryDelay;

    public SyncMovementMsg(PlayerMovement h) {
        this.state = h.getState();
        this.stamina = h.getStamina();
        this.depleted = h.isDepleted();
        this.recoveryDelay = h.getRecoveryDelay();
    }

    public SyncMovementMsg(PlayerState state, int stamina, boolean depleted, int recoveryDelay) {
        this.state = state;
        this.stamina = stamina;
        this.depleted = depleted;
        this.recoveryDelay = recoveryDelay;
    }

    public void copyTo(PlayerMovement h) {
        h.setState(this.state);
        h.setStamina(this.stamina);
        h.setDepleted(this.depleted);
        h.setRecoveryDelay(this.recoveryDelay);
    }

    public void write(PacketBuffer buffer) {
        buffer.writeByte(this.state.ordinal());
        buffer.writeInt(this.stamina);
        buffer.writeBoolean(this.depleted);
        buffer.func_150787_b(this.recoveryDelay);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("stamina", this.stamina).add("depleted", this.depleted).add("recoveryDelay", this.recoveryDelay).toString();
    }

    public static SyncMovementMsg read(PacketBuffer buffer) {
        return new SyncMovementMsg(PlayerState.of(buffer.readUnsignedByte()), buffer.readInt(), buffer.readBoolean(), buffer.func_150792_a());
    }
}

